<?php

namespace App\Events;

use App\Models\Battle;
use App\Models\User;
use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class BattleAbandoned implements ShouldBroadcast
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public Battle $battle;
    public User $user;

    public function __construct(Battle $battle, User $user)
    {
        $this->battle = $battle;
        $this->user = $user;
    }

    public function broadcastOn(): array
    {
        return [
            new PrivateChannel('battle.' . $this->battle->id),
        ];
    }

    public function broadcastAs(): string
    {
        return 'battle.abandoned';
    }

    public function broadcastWith(): array
    {
        return [
            'battle' => $this->battle->toArray(),
            'abandoned_user_id' => $this->user->id,
        ];
    }
}
