<?php

namespace App\Events;

use App\Models\Battle;
use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class BattleJoined implements ShouldBroadcast
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public Battle $battle;

    public function __construct(Battle $battle)
    {
        $this->battle = $battle;
    }

    public function broadcastOn(): array
    {
        return [
            new PrivateChannel('battle.' . $this->battle->id),
        ];
    }

    public function broadcastAs(): string
    {
        return 'battle.joined';
    }

    public function broadcastWith(): array
    {
        return [
            'battle' => $this->battle->toArray(),
        ];
    }
}
