<?php

namespace App\Events;

use App\Models\Battle; // <-- Importez votre modèle
use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Broadcasting\PresenceChannel;
use Illuminate\Broadcasting\PrivateChannel; // <-- Important
use Illuminate\Contracts\Broadcasting\ShouldBroadcast; // <-- Très important
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class BattleUpdated implements ShouldBroadcast
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    // Rendez votre bataille publique pour qu'elle soit envoyée
    public Battle $battle;

    /**
     * Create a new event instance.
     */
    public function __construct(Battle $battle)
    {
        $this->battle = $battle;
    }

    /**
     * Get the channels the event should broadcast on.
     */
    public function broadcastOn(): array
    {
        // Diffuser sur le canal privé de CETTE bataille
        return [
            new PrivateChannel('private-battle.' . $this->battle->id),
        ];
    }

    /**
     * Le nom de l'événement que Flutter écoutera.
     */
    public function broadcastAs(): string
    {
        return 'battle.updated';
    }
}