<?php

namespace App\Events;

use App\Models\Battle;
use App\Models\User;
use Illuminate\Broadcasting\Channel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class ScoreUpdated implements ShouldBroadcast
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public Battle $battle;
    public User $user;
    public int $questionIndex;
    public bool $isCorrect;

    public function __construct(Battle $battle, User $user, int $questionIndex, bool $isCorrect)
    {
        $this->battle = $battle;
        $this->user = $user;
        $this->questionIndex = $questionIndex;
        $this->isCorrect = $isCorrect;
    }

    public function broadcastOn(): array
    {
        return [
            new PrivateChannel('battle.' . $this->battle->id),
        ];
    }

    public function broadcastAs(): string
    {
        return 'battle.score.updated';
    }

    public function broadcastWith(): array
    {
        return [
            'player_id' => $this->user->id,
            'question_index' => $this->questionIndex,
            'is_correct' => $this->isCorrect,
            'player1_score' => $this->battle->player1_score,
            'player2_score' => $this->battle->player2_score,
        ];
    }
}
