<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Services\LeaderboardService;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;

class LeaderboardController extends Controller
{
    protected LeaderboardService $leaderboardService;

    public function __construct(LeaderboardService $leaderboardService)
    {
        $this->leaderboardService = $leaderboardService;
    }

    public function index(Request $request): JsonResponse
    {
        $top100 = $this->leaderboardService->getTop100();
        return response()->json($top100);
    }

    public function rank(Request $request): JsonResponse
    {
        $userId = $request->input('user_id');
        $user = \App\Models\User::findOrFail($userId);
        $rank = $this->leaderboardService->getUserRank($user);
        return response()->json(['rank' => $rank]);
    }

    public function myRank(Request $request): JsonResponse
    {
        $user = $request->user();
        $rank = $this->leaderboardService->getUserRank($user);
        return response()->json(['rank' => $rank]);
    }
}
