<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Services\SyncService;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;

class SyncController extends Controller
{
    protected SyncService $syncService;

    public function __construct(SyncService $syncService)
    {
        $this->syncService = $syncService;
    }

    public function syncToServer(Request $request): JsonResponse
    {
        $user = $request->user();
        $data = $request->all();

        try {
            $this->syncService->syncToServer($user, $data);
            return response()->json(['message' => 'Data synchronized successfully']);
        } catch (\Exception $e) {
            return response()->json(['error' => $e->getMessage()], 400);
        }
    }

    public function syncFromServer(Request $request): JsonResponse
    {
        $user = $request->user();
        $data = $this->syncService->syncFromServer($user);
        return response()->json($data);
    }

    public function syncLevelProgress(Request $request): JsonResponse
    {
        $user = $request->user();
        $levelData = $request->all();

        try {
            $this->syncService->syncLevelProgress($user, $levelData);
            return response()->json(['message' => 'Level progress synchronized successfully']);
        } catch (\Exception $e) {
            return response()->json(['error' => $e->getMessage()], 400);
        }
    }

    public function syncUnlockedHints(Request $request): JsonResponse
    {
        $user = $request->user();
        $hints = $request->input('hints', []);

        $userData = $user->userData;
        if (!$userData) {
            $userData = \App\Models\UserData::create(['user_id' => $user->id]);
        }

        $userData->unlocked_hints = $hints;
        $userData->save();

        return response()->json(['message' => 'Unlocked hints synchronized successfully']);
    }
}
