<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;

class UserController extends Controller
{
    public function show(Request $request): JsonResponse
    {
        $user = $request->user();
        return response()->json($user);
    }

    public function update(Request $request): JsonResponse
    {
        $user = $request->user();
        $user->update($request->only(['display_name', 'photo_url']));
        return response()->json($user);
    }

    public function stats(Request $request): JsonResponse
    {
        $user = $request->user();
        $userData = $user->userData;
        return response()->json([
            'stats' => $userData->stats ?? null,
        ]);
    }

    public function progress(Request $request): JsonResponse
    {
        $user = $request->user();
        $levelProgress = $user->levelProgress;
        return response()->json([
            'progress' => $levelProgress,
        ]);
    }
}
