<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use App\Services\FirebaseAuthService;

class FirebaseAuthMiddleware
{
    protected FirebaseAuthService $firebaseAuthService;

    public function __construct(FirebaseAuthService $firebaseAuthService)
    {
        $this->firebaseAuthService = $firebaseAuthService;
    }

    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $token = $request->bearerToken();

        if (!$token) {
            return response()->json(['error' => 'Unauthorized. Token missing.'], 401);
        }

        $uid = $this->firebaseAuthService->verifyToken($token);

        if (!$uid) {
            return response()->json(['error' => 'Unauthorized. Invalid token.'], 401);
        }

        $user = $this->firebaseAuthService->findOrCreateUser($uid);

        if (!$user) {
            return response()->json(['error' => 'Unauthorized. User not found.'], 401);
        }

        $request->setUserResolver(function () use ($user) {
            return $user;
        });

        return $next($request);
    }
}
