<?php

namespace App\Jobs;

use App\Models\Battle;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Queue\Queueable;
use Carbon\Carbon;

class CleanupOldBattles implements ShouldQueue
{
    use Queueable;

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        // Cleanup waiting battles older than 5 minutes
        Battle::where('status', 'waiting')
            ->where('created_at', '<', Carbon::now()->subMinutes(5))
            ->delete();

        // Cleanup finished battles older than 1 hour
        Battle::where('status', 'finished')
            ->where('end_time', '<', Carbon::now()->subHour())
            ->delete();
    }
}
