<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Battle extends Model
{
    protected $fillable = [
        'room_id',
        'mode',
        'status',
        'player1_id',
        'player2_id',
        'questions',
        'player1_score',
        'player2_score',
        'player1_question_index',
        'player2_question_index',
        'player1_answered_questions',
        'player2_answered_questions',
        'player1_abandoned',
        'player2_abandoned',
        'winner_id',
        'result',
        'total_time_limit',
        'start_time',
        'end_time',
    ];

    protected function casts(): array
    {
        return [
            'questions' => 'array',
            'player1_answered_questions' => 'array',
            'player2_answered_questions' => 'array',
            'player1_abandoned' => 'boolean',
            'player2_abandoned' => 'boolean',
            'start_time' => 'datetime',
            'end_time' => 'datetime',
        ];
    }

    public function player1(): BelongsTo
    {
        return $this->belongsTo(User::class, 'player1_id');
    }

    public function player2(): BelongsTo
    {
        return $this->belongsTo(User::class, 'player2_id');
    }

    public function winner(): BelongsTo
    {
        return $this->belongsTo(User::class, 'winner_id');
    }
}
