<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class LevelProgress extends Model
{
    protected $fillable = [
        'user_id',
        'level_id',
        'is_completed',
        'best_time',
        'attempts',
        'last_played_at',
    ];

    protected function casts(): array
    {
        return [
            'is_completed' => 'boolean',
            'last_played_at' => 'datetime',
        ];
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }
}
