<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasOne;

class User extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'firebase_uid',
        'display_name',
        'email',
        'photo_url',
        'points',
        'trophies',
        'completed_levels',
        'last_sync_at',
    ];

    /**
     * The attributes that should be cast.
     *
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'last_sync_at' => 'datetime',
        ];
    }

    /**
     * Get the user data for the user.
     */
    public function userData(): HasOne
    {
        return $this->hasOne(UserData::class);
    }

    /**
     * Get the level progress for the user.
     */
    public function levelProgress(): HasMany
    {
        return $this->hasMany(LevelProgress::class);
    }

    /**
     * Get the battles where the user is player 1.
     */
    public function battlesAsPlayer1(): HasMany
    {
        return $this->hasMany(Battle::class, 'player1_id');
    }

    /**
     * Get the battles where the user is player 2.
     */
    public function battlesAsPlayer2(): HasMany
    {
        return $this->hasMany(Battle::class, 'player2_id');
    }

    /**
     * Get the battles won by the user.
     */
    public function battlesWon(): HasMany
    {
        return $this->hasMany(Battle::class, 'winner_id');
    }

    /**
     * Get the leaderboard entry for the user.
     */
    public function leaderboard(): HasOne
    {
        return $this->hasOne(Leaderboard::class);
    }
}
