<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class UserData extends Model
{
    protected $fillable = [
        'user_id',
        'stats',
        'level_progress',
        'unlocked_hints',
    ];

    protected function casts(): array
    {
        return [
            'stats' => 'array',
            'level_progress' => 'array',
            'unlocked_hints' => 'array',
        ];
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }
}
