<?php

namespace App\Services;

use App\Models\Leaderboard;
use App\Models\User;

class LeaderboardService
{
    /**
     * Update leaderboard
     */
    public function updateLeaderboard(): void
    {
        $users = User::orderBy('trophies', 'desc')
            ->orderBy('points', 'desc')
            ->get();

        $rank = 1;
        foreach ($users as $user) {
            Leaderboard::updateOrCreate(
                ['user_id' => $user->id],
                [
                    'rank' => $rank++,
                    'trophies' => $user->trophies,
                    'updated_at' => now(),
                ]
            );
        }
    }

    /**
     * Get top 100
     */
    public function getTop100(): array
    {
        return Leaderboard::with('user')
            ->orderBy('rank', 'asc')
            ->limit(100)
            ->get()
            ->map(function ($entry) {
                return [
                    'rank' => $entry->rank,
                    'user' => [
                        'id' => $entry->user->id,
                        'display_name' => $entry->user->display_name,
                        'photo_url' => $entry->user->photo_url,
                        'trophies' => $entry->trophies,
                        'points' => $entry->user->points,
                    ],
                ];
            })
            ->toArray();
    }

    /**
     * Get user rank
     */
    public function getUserRank(User $user): ?int
    {
        $leaderboard = Leaderboard::where('user_id', $user->id)->first();
        return $leaderboard ? $leaderboard->rank : null;
    }
}

