<?php

namespace App\Services;

use App\Models\Battle;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
// SUPPRIMER LES IMPORTS D'ÉVÉNEMENTS
// SUPPRIMER L'IMPORT BattleService

class MatchmakingService
{
    // PAS DE CONSTRUCTEUR NÉCESSAIRE (corrige la récursion)

    /**
     * Find a waiting battle (NE REJOINT PAS, Node.js s'en occupe)
     * Utilise une transaction avec verrou pour éviter les race conditions
     */
    public function findWaitingBattle(User $user, string $mode = 'ranked'): ?Battle
    {
        // Utiliser une transaction pour éviter les race conditions
        // Si deux clients cherchent en même temps, seul le premier trouvera la bataille
        return DB::transaction(function () use ($user, $mode) {
            $battle = Battle::where('mode', $mode)
                ->where('status', 'waiting')
                ->where('player1_id', '!=', $user->id) // Ne pas rejoindre sa propre partie
                ->whereNull('player2_id')
                ->where('created_at', '>', now()->subMinutes(5)) 
                ->orderBy('created_at', 'asc')
                ->lockForUpdate() // Verrouiller la ligne pour éviter les conflits
                ->first();

            // On ne met RIEN à jour ici, on retourne juste ce qu'on a trouvé
            return $battle;
        });
    }

    /**
     * Find a friendly battle by room ID (Cette fonction est correcte)
     */
    public function findFriendlyBattle(string $roomId): ?Battle
    {
        return Battle::where('room_id', $roomId)
            ->where('mode', 'friendly')
            ->where('status', 'waiting')
            ->first();
    }
}