<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Firebase Credentials Path
    |--------------------------------------------------------------------------
    |
    | Chemin vers le fichier JSON des credentials Firebase.
    | Vous pouvez le définir ici directement ou via la variable d'environnement
    | FIREBASE_CREDENTIALS_PATH dans votre fichier .env
    |
    | Par défaut: storage/app/firebase-credentials.json
    |
    | Pour configurer directement (sans .env), modifiez la ligne ci-dessous :
    | 'credentials_path' => storage_path('app/firebase-credentials.json'),
    |
    */

    // Configuration Firebase Credentials Path
    // Priorité : 1. Variable .env FIREBASE_CREDENTIALS_PATH, 2. Chemin par défaut
    // Si le chemin dans .env est relatif, il sera converti en absolu par le service
    'credentials_path' => env('FIREBASE_CREDENTIALS_PATH', storage_path('app/firebase-credentials.json')),
];
