<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Cette migration est maintenant inutile car nous avons modifié la migration initiale
        // Mais nous la gardons au cas où la table users existe déjà avec l'ancien schéma
        if (Schema::hasColumn('users', 'name')) {
            Schema::table('users', function (Blueprint $table) {
                // Renommer name en display_name si la colonne name existe
                $table->renameColumn('name', 'display_name');
            });
        }
        
        if (!Schema::hasColumn('users', 'firebase_uid')) {
            Schema::table('users', function (Blueprint $table) {
                $table->string('firebase_uid')->unique()->after('id');
            });
        }
        
        if (!Schema::hasColumn('users', 'points')) {
            Schema::table('users', function (Blueprint $table) {
                $table->integer('points')->default(500)->after('photo_url');
                $table->integer('trophies')->default(0);
                $table->integer('completed_levels')->default(0);
                $table->timestamp('last_sync_at')->nullable();
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Pas de rollback nécessaire si la migration initiale a été modifiée
    }
};
