<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('battles', function (Blueprint $table) {
            $table->id();
            $table->string('room_id')->nullable()->unique();
            $table->enum('mode', ['ranked', 'friendly'])->default('ranked');
            $table->enum('status', ['waiting', 'active', 'finished'])->default('waiting');
            $table->foreignId('player1_id')->constrained('users')->onDelete('cascade');
            $table->foreignId('player2_id')->nullable()->constrained('users')->onDelete('cascade');
            $table->json('questions')->nullable();
            $table->integer('player1_score')->default(0);
            $table->integer('player2_score')->default(0);
            $table->integer('player1_question_index')->default(0);
            $table->integer('player2_question_index')->default(0);
            $table->json('player1_answered_questions')->nullable();
            $table->json('player2_answered_questions')->nullable();
            $table->boolean('player1_abandoned')->default(false);
            $table->boolean('player2_abandoned')->default(false);
            $table->foreignId('winner_id')->nullable()->constrained('users')->onDelete('set null');
            $table->string('result')->nullable(); // 'player1_win', 'player2_win', 'draw'
            $table->integer('total_time_limit')->default(300); // 5 minutes en secondes
            $table->timestamp('start_time')->nullable();
            $table->timestamp('end_time')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('battles');
    }
};
