<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Obtenir Token Firebase - Cadenas</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            padding: 20px;
        }

        .container {
            background: white;
            border-radius: 20px;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
            max-width: 700px;
            width: 100%;
            padding: 40px;
        }

        h1 {
            color: #333;
            margin-bottom: 10px;
            font-size: 28px;
        }

        .subtitle {
            color: #666;
            margin-bottom: 30px;
            font-size: 14px;
        }

        .info-box {
            background: #fff3cd;
            border: 2px solid #ffc107;
            border-radius: 8px;
            padding: 20px;
            margin-bottom: 30px;
        }

        .info-box h3 {
            color: #856404;
            margin-bottom: 15px;
        }

        .info-box ol {
            margin-left: 20px;
            color: #856404;
        }

        .info-box li {
            margin-bottom: 10px;
        }

        .code-block {
            background: #f4f4f4;
            padding: 15px;
            border-radius: 8px;
            margin: 10px 0;
            font-family: 'Courier New', monospace;
            font-size: 12px;
            overflow-x: auto;
        }

        .method-section {
            background: #f8f9fa;
            border-radius: 10px;
            padding: 20px;
            margin-bottom: 20px;
        }

        .method-section h2 {
            color: #333;
            font-size: 20px;
            margin-bottom: 15px;
        }

        .form-group {
            margin-bottom: 20px;
        }

        label {
            display: block;
            margin-bottom: 8px;
            color: #333;
            font-weight: 600;
            font-size: 14px;
        }

        input[type="text"],
        input[type="email"],
        input[type="password"] {
            width: 100%;
            padding: 12px;
            border: 2px solid #e0e0e0;
            border-radius: 8px;
            font-size: 14px;
            transition: border-color 0.3s;
        }

        input:focus {
            outline: none;
            border-color: #667eea;
        }

        button {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            padding: 12px 30px;
            border-radius: 8px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            width: 100%;
            transition: transform 0.2s, box-shadow 0.2s;
        }

        button:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(102, 126, 234, 0.4);
        }

        button:disabled {
            opacity: 0.6;
            cursor: not-allowed;
            transform: none;
        }

        .result {
            margin-top: 20px;
            padding: 15px;
            border-radius: 8px;
            display: none;
        }

        .result.success {
            background: #d4edda;
            border: 2px solid #28a745;
            color: #155724;
        }

        .result.error {
            background: #f8d7da;
            border: 2px solid #dc3545;
            color: #721c24;
        }

        .result pre {
            margin: 10px 0 0 0;
            white-space: pre-wrap;
            word-wrap: break-word;
            font-size: 12px;
            max-height: 300px;
            overflow-y: auto;
            background: rgba(0,0,0,0.1);
            padding: 10px;
            border-radius: 5px;
        }

        .token-display {
            background: #f4f4f4;
            padding: 15px;
            border-radius: 8px;
            margin-top: 15px;
            font-family: 'Courier New', monospace;
            font-size: 11px;
            word-break: break-all;
            max-height: 200px;
            overflow-y: auto;
        }

        .copy-btn {
            background: #28a745;
            margin-top: 10px;
        }

        .copy-btn:hover {
            background: #218838;
        }

        a {
            color: #667eea;
            text-decoration: none;
        }

        a:hover {
            text-decoration: underline;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>🔑 Comment Obtenir un Token Firebase</h1>
        <p class="subtitle">Guide simple pour obtenir un token Firebase de test</p>

        <div class="info-box">
            <h3>📋 Méthode Recommandée : Depuis votre Application Mobile</h3>
            <ol>
                <li><strong>Ouvrez votre application mobile</strong> (iOS/Android/Flutter)</li>
                <li><strong>Connectez-vous</strong> avec un compte utilisateur</li>
                <li><strong>Ajoutez ce code</strong> pour afficher le token (voir exemples ci-dessous)</li>
                <li><strong>Copiez le token</strong> affiché</li>
                <li><strong>Collez-le</strong> dans la <a href="/test-firebase-page">page de test</a></li>
            </ol>
        </div>

        <!-- Méthode 1: Flutter -->
        <div class="method-section">
            <h2>📱 Méthode 1 : Flutter (Dart)</h2>
            <p style="color: #666; margin-bottom: 15px;">Ajoutez ce code dans votre application Flutter :</p>
            <div class="code-block">
import 'package:firebase_auth/firebase_auth.dart';
import 'package:flutter/services.dart';

// Créez un bouton dans votre UI
ElevatedButton(
  onPressed: () async {
    User? user = FirebaseAuth.instance.currentUser;
    if (user != null) {
      String? token = await user.getIdToken();
      if (token != null) {
        // Afficher le token
        showDialog(
          context: context,
          builder: (context) => AlertDialog(
            title: Text('Firebase Token'),
            content: SingleChildScrollView(
              child: SelectableText(token, style: TextStyle(fontSize: 10)),
            ),
            actions: [
              TextButton(
                onPressed: () {
                  Clipboard.setData(ClipboardData(text: token));
                  ScaffoldMessenger.of(context).showSnackBar(
                    SnackBar(content: Text('Token copié!')),
                  );
                },
                child: Text('Copier'),
              ),
            ],
          ),
        );
        // Aussi imprimer dans la console
        print('🔑 TOKEN: $token');
      }
    }
  },
  child: Text('🔑 Obtenir Token'),
)
            </div>
        </div>

        <!-- Méthode 2: iOS -->
        <div class="method-section">
            <h2>🍎 Méthode 2 : iOS (Swift)</h2>
            <div class="code-block">
import FirebaseAuth

Auth.auth().currentUser?.getIDToken { token, error in
    if let token = token {
        print("🔑 TOKEN: \(token)")
        // Affichez le token dans une alert ou copiez-le
    }
}
            </div>
        </div>

        <!-- Méthode 3: Android -->
        <div class="method-section">
            <h2>🤖 Méthode 3 : Android (Kotlin)</h2>
            <div class="code-block">
FirebaseAuth.getInstance().currentUser?.getIdToken(true)
    ?.addOnSuccessListener { result ->
        val token = result.token
        Log.d("Firebase", "🔑 TOKEN: $token")
        // Affichez le token ou copiez-le
    }
            </div>
        </div>

        <!-- Méthode 4: Créer un utilisateur de test -->
        <div class="method-section">
            <h2>🧪 Méthode 4 : Créer un Utilisateur de Test</h2>
            <p style="color: #666; margin-bottom: 15px;">Si vous n'avez pas encore d'utilisateur :</p>
            <ol style="margin-left: 20px; color: #666;">
                <li>Allez sur <a href="https://console.firebase.google.com/" target="_blank">Firebase Console</a></li>
                <li>Authentication > Users > Add user</li>
                <li>Créez un utilisateur avec email/mot de passe</li>
                <li>Connectez-vous dans votre app avec cet utilisateur</li>
                <li>Récupérez le token avec le code ci-dessus</li>
            </ol>
        </div>

        <!-- Lien vers la page de test -->
        <div style="text-align: center; margin-top: 30px; padding: 20px; background: #e7f3ff; border-radius: 10px;">
            <h3 style="color: #1976D2; margin-bottom: 10px;">✅ Une fois le Token Obtenu</h3>
            <p style="color: #666; margin-bottom: 15px;">Collez-le dans la page de test pour vérifier qu'il fonctionne</p>
            <a href="/test-firebase-page" style="display: inline-block; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; padding: 12px 30px; border-radius: 8px; text-decoration: none; font-weight: 600;">🧪 Aller à la Page de Test</a>
        </div>
    </div>
</body>
</html>

