<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\UserController;
use App\Http\Controllers\Api\BattleController;
use App\Http\Controllers\Api\LeaderboardController;
use App\Http\Controllers\Api\SyncController;
// use App\Http\Controllers\BroadcastingController; // <-- SUPPRIMÉ
use App\Http\Middleware\FirebaseAuthMiddleware;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
*/

// Route de diffusion Pusher (supprimée)
// Route::post('/broadcasting/auth', [BroadcastingController::class, 'authenticate']); // <-- SUPPRIMÉ

Route::middleware([FirebaseAuthMiddleware::class])->group(function () {
    // User routes
    // CORRECTION: Assurez-vous d'avoir une route pour '/user'
    // Node.js appelle cette route pour l'authentification
    Route::get('/user', [UserController::class, 'show']); 
    Route::put('/user', [UserController::class, 'update']);
    Route::get('/user/stats', [UserController::class, 'stats']);
    Route::get('/user/progress', [UserController::class, 'progress']);

    // Battle routes
    Route::post('/battles', [BattleController::class, 'create']);
    Route::get('/battles/{battle}', [BattleController::class, 'show']);
    Route::post('/battles/{battle}/join', [BattleController::class, 'join']);
    Route::post('/battles/{battle}/abandon', [BattleController::class, 'abandon']);
    Route::post('/battles/{battle}/answer', [BattleController::class, 'answer']);
    Route::delete('/battles/{battle}', [BattleController::class, 'destroy']);
    Route::get('/battles/waiting', [BattleController::class, 'findWaiting']);
    Route::get('/battles/friendly/{roomId}', [BattleController::class, 'findFriendly']);

    // Leaderboard routes
    Route::get('/leaderboard', [LeaderboardController::class, 'index']);
    Route::get('/leaderboard/rank', [LeaderboardController::class, 'rank']);
    Route::get('/leaderboard/my-rank', [LeaderboardController::class, 'myRank']);

    // Sync routes
    Route::post('/sync', [SyncController::class, 'syncToServer']);
    Route::get('/sync', [SyncController::class, 'syncFromServer']);
    Route::post('/sync/level-progress', [SyncController::class, 'syncLevelProgress']);
    Route::post('/sync/unlocked-hints', [SyncController::class, 'syncUnlockedHints']);
});