<?php

use Illuminate\Foundation\Inspiring;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\Schedule;
use App\Jobs\CleanupOldBattles;
use App\Services\LeaderboardService;

Artisan::command('inspire', function () {
    $this->comment(Inspiring::quote());
})->purpose('Display an inspiring quote');

Schedule::job(new CleanupOldBattles)->hourly();

Schedule::call(function () {
    $leaderboardService = app(LeaderboardService::class);
    $leaderboardService->updateLeaderboard();
})->hourly();
