<?php

use Illuminate\Support\Facades\Route;
use App\Services\FirebaseAuthService;
use App\Http\Middleware\FirebaseAuthMiddleware;
use App\Http\Controllers\BroadcastingController;

Route::get('/', function () {
    return view('welcome');
});

// NOTE: La route /broadcasting/auth a été déplacée dans routes/api.php
// pour éviter les conflits avec la route par défaut de Laravel

// Page de test Firebase Auth
Route::get('/test-firebase-page', function () {
    return view('test-firebase');
})->name('test.firebase.page');

// Page pour obtenir un token Firebase (instructions)
Route::get('/get-firebase-token', function () {
    return view('get-firebase-token-simple');
})->name('get.firebase.token');

// Route de test pour Firebase Auth (à supprimer en production)
Route::get('/test-firebase-auth', function () {
    try {
        $service = new FirebaseAuthService();
        return response()->json([
            'status' => 'success',
            'message' => 'Firebase service initialized successfully',
            'credentials_path' => config('firebase.credentials_path'),
            'file_exists' => file_exists(config('firebase.credentials_path')),
        ]);
    } catch (Exception $e) {
        return response()->json([
            'status' => 'error',
            'message' => $e->getMessage(),
        ], 500);
    }
})->name('test.firebase');

// Route de test pour vérifier un token (à supprimer en production)
Route::post('/test-firebase-token', function (Illuminate\Http\Request $request) {
    $token = $request->input('token') ?: $request->bearerToken();
    
    if (!$token) {
        return response()->json([
            'status' => 'error',
            'message' => 'Token manquant. Envoyez-le via POST {token: "..."} ou header Authorization: Bearer ...',
        ], 400);
    }
    
    try {
        $service = new FirebaseAuthService();
        $uid = $service->verifyToken($token);
        
        if (!$uid) {
            return response()->json([
                'status' => 'error',
                'message' => 'Token invalide ou expiré',
            ], 401);
        }
        
        $userData = $service->getUserData($uid);
        $user = $service->findOrCreateUser($uid);
        
        return response()->json([
            'status' => 'success',
            'message' => 'Token valide',
            'firebase_uid' => $uid,
            'user_data' => $userData,
            'user' => $user,
        ]);
    } catch (Exception $e) {
        return response()->json([
            'status' => 'error',
            'message' => $e->getMessage(),
        ], 500);
    }
})->name('test.firebase.token');
